<!-- Make sure you put this AFTER Leaflet's CSS -->

 <script src="https://unpkg.com/leaflet@1.3.4/dist/leaflet.js" integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA=="

   crossorigin=""></script>

 <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCHqhgVQmhdp3XAJ91LHRdXJ3YOjP1V2Gs" async defer></script>



 <script src="assets/js/leaflet-panel-layers-master/src/leaflet-panel-layers.js"></script>

 <script src="assets/js/leaflet.ajax.js"></script>

 <script src="assets/js/Leaflet.GoogleMutant.js"></script>



<script type="text/javascript">

		<?php

 			if ($session->get('level')=='Admin' OR $session->get('level')=='User'){

 				$lat = "3.2304447";

 				$long = "99.315189";

 				$zoom = 11;

			}else {

				$db->where("kecamatan",$session->get('lokasi'));

				$data=$db->ObjectBuilder()->getOne('m_kecamatan');

				if($db->count>0){

					$lat = $data->latitude;

   				$long = $data->longitude;

   				$zoom = $data->zoom;

				}					

			}

   	?>



   	var map = L.map('mapid').setView([<?=$lat?>,<?=$long?>], <?=$zoom?>);

   	map.zoomControl.setPosition('topright');



    var LayerKita = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {

          maxZoom: 19,

          attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'

    });

    var roadMutant = L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'roadmap'

		});

	map.addLayer(LayerKita);



	var myStyle2 = {

	    "color": "#ffff00",

	    "weight": 1,

	    "opacity": 0.9

	};



	function popUp(f,l){

	    var out = [];

	    if (f.properties){

					for(key in f.properties){

              out.push(key+": "+f.properties[key]);

          }

          l.bindPopup(out.join("<br />"));

	    }

	}



	// legend



	function iconByName(name) {

		return '<i class="icon" style="background-color:'+name+';border-radius:50%"></i>';

	}



	function featureToMarker(feature, latlng) {

		return L.marker(latlng, {

			icon: L.divIcon({

				className: 'marker-'+feature.properties.amenity,

				html: iconByName(feature.properties.amenity),

				iconUrl: '../images/markers/'+feature.properties.amenity+'.png',

				iconSize: [25, 41],

				iconAnchor: [12, 41],

				popupAnchor: [1, -34],

				shadowSize: [41, 41]

			})

		});

	}



	var baseLayers = [

		{

			name: "OpenStreetMap",

			layer: LayerKita

		},

		{

			name: "OpenCycleMap",

			layer: L.tileLayer('http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png')

		},

		{

			name: "Outdoors",

			layer: L.tileLayer('http://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png')

		},

		{

			name:'Satelite Google',

			layer : L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'satellite'

			})

		},

		{

			name: "Roadmap Google",

			layer: roadMutant

		}

	];



	<?php

		if ($session->get('level')=='Admin' OR $session->get('level')=='User'){

			$getKecamatan=$db->ObjectBuilder()->get('m_desa');

		}elseif ($session->get('level')=='Kecamatan') {

			$db->where("kecamatan",$session->get('lokasi'));

			$getKecamatan=$db->ObjectBuilder()->get('m_desa');

		}

		foreach ($getKecamatan as $row) {

			?>



			var myStyle<?=$row->id?> = {

			    "color": "<?=$row->warna_desa?>",

			    "weight": 3,

			    "opacity": 2

			};



			<?php

			$arrayKec[]='{

			name: "'.$row->nama_desa.'",

			icon: iconByName("'.$row->warna_desa.'"),

			layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/BatasDesa/'.$row->geojson_desa.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

			}';

		}

	?>



	<?php

		if($session->get('lokasi')==''){

			$lokasi = "Kab. Batu Bara";

		}else{

			$lokasi = "Kec. ".$session->get('lokasi');

		}

	?>

	var overLayers = [{

		group: "Daftar Desa <?=$lokasi?>",

		layers: [

			<?=implode(',', $arrayKec);?>

		]

	}

	];



	var panelLayers = new L.Control.PanelLayers(baseLayers, overLayers,{

		collapsibleGroups: true,

		position:'topleft'

	});



	map.addControl(panelLayers);



	// marker

	var myIcon = L.icon({

	    iconUrl: '<?=assets('icons/marker.png')?>',

	    iconSize: [38, 45],

	});

	<?php

	if($cari!=''){

		$db->where('alsintan','%'.$cari.'%','LIKE');

	}

	if($tahun!='semua'){

		$db->where('tahun',$tahun);

	}



	if ($session->get('level')=='Admin' OR $session->get('level')=='User'){

		$getdata=$db->ObjectBuilder()->get('alsintan');

	}elseif ($session->get('level')=='Kecamatan') {

		$db->where("kecamatan",$session->get('lokasi'));

		$getdata=$db->ObjectBuilder()->get('alsintan');

	}

	foreach ($getdata as $row) {

		?>

		L.marker([<?=$row->latitude?>,<?=$row->longitude?>],{icon: myIcon}).addTo(map)

				.bindPopup("KECAMATAN : <?=$row->kecamatan?><br>DESA : <?=$row->desa?><br>NAMA KELOMPOK : <?=$row->nama_kelompok?><br>NAMA KETUA : <?=$row->nama_ketua?><br>ALSINTAN : <?=$row->alsintan?><br>JUMLAH : <?=$row->jumlah_unit?><br>TAHUN : <?=$row->tahun?><br>KETERANGAN : <?=$row->keterangan?>");

		<?php

	}

	?>



   </script>

