

<!-- Make sure you put this AFTER Leaflet's CSS -->

  <script src="https://unpkg.com/leaflet@1.3.4/dist/leaflet.js" integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA=="

   crossorigin=""></script>

 <!-- <link rel="stylesheet" href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" integrity="sha512-xwE/Az9zrjBIphAcBb3F6JVqxf46+CDLwfLMHloNu6KEQCAWi6HcDUbeOfBIptF7tcCzusKFjFw2yuvEpDL9wQ==" crossorigin=""/> -->



 <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCHqhgVQmhdp3XAJ91LHRdXJ3YOjP1V2Gs" async defer></script> 





 <script src="assets/js/leaflet-panel-layers-master/src/leaflet-panel-layers.js"></script>

 <script src="assets/js/leaflet-compass-master/src/leaflet-compass.js"></script>

 <script src="assets/js/leaflet-search/dist/leaflet-search.src.js"></script>



 <script src="assets/js/leaflet.ajax.js"></script>

 <script src="assets/js/Leaflet.GoogleMutant.js"></script>



   <script type="text/javascript">



   	// var map = L.map('mapid').setView([3.2352436, 99.3412807], 10);

		var map = L.map('mapid').setView([3.2304447,99.315189], 11);

		map.zoomControl.setPosition('topright');



    var LayerKita = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {

          maxZoom: 19,

          attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'

    });

    var roadMutant = L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'roadmap'

		});

	map.addLayer(LayerKita);



	function popUp(f,l){

	    var out = [];

	    if (f.properties){

					for(key in f.properties){

              out.push(key+": "+f.properties[key]);

          }

          l.bindPopup(out.join("<br />"));

          l.bindTooltip(f.properties['<B>KECAMATAN</B>'],{

	        	permanent:true,

	        	direction:"center",

	        	className:"no-background"

	        });

	    }

	}





	// legend



	function iconByName(name) {

		return '<i class="icon" style="background-color:'+name+';border-radius:50%"></i>';

	}



	function featureToMarker(feature, latlng) {

		return L.marker(latlng, {

			icon: L.divIcon({

				className: 'marker-'+feature.properties.amenity,

				html: iconByName(feature.properties.amenity),

				iconUrl: '../images/markers/'+feature.properties.amenity+'.png',

				iconSize: [25, 41],

				iconAnchor: [12, 41],

				popupAnchor: [1, -34],

				shadowSize: [41, 41]

			})

		});

	}



	var baseLayers = [

		{

			name: "OpenStreetMap",

			layer: LayerKita

		},

		{

			name: "OpenCycleMap",

			layer: L.tileLayer('http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png')

		},

		{

			name: "Outdoors",

			layer: L.tileLayer('http://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png')

		},

		{

			name:'Satelite Google',

			layer : L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'satellite'

			})

		},

		{

			name: "Roadmap Google",

			layer: roadMutant

		}

	];



	<?php



		switch ($jenisdata) {

		  case "kecamatan":

		  	if($kecamatan=='semua'){

		  		$getdata=$db->ObjectBuilder()->get('m_kecamatan');

		  		$nama = 'kecamatan';

		  		$color = 'warna_kecamatan';

		  		$lokasi = 'BatasKab';

		  		$json = 'geojson_kecamatan';

		  	}

		  	else{

		  		if($desa=='semua'){

		  			$db->where("kecamatan",$kecamatan);

						$getdata=$db->ObjectBuilder()->get('m_kecamatan');

						$nama = 'kecamatan';

						$color = 'warna_kecamatan';

						$lokasi = 'BatasKab';

						$json = 'geojson_kecamatan';

		  		}else{

		  			$db->where("kecamatan",$kecamatan);

		  			$db->where("nama_desa",$desa);

						$getdata=$db->ObjectBuilder()->get('m_desa');

						$nama = 'nama_desa';

						$color = 'warna_desa';

						$lokasi = 'BatasDesa';

						$json = 'geojson_desa';

		  		}		  		

		  	}

		  	foreach ($getdata as $row) {

		?>



		  	var myStyle<?=$row->id?> = {

			    "color": "<?=$row->$color?>",

			    "weight": 3,

			    "opacity": 2

				};

		<?php

						$arrayKec[]='{

						name: "'.$row->$nama.'",

						icon: iconByName("'.$row->$color.'"),

						layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$lokasi.'/'.$row->$json.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

						}';

					}



			break;





			case "desa":

		  	if($kecamatan=='semua'){

		  		$getdata=$db->ObjectBuilder()->get('m_kecamatan');

		  		$nama = 'kecamatan';

		  		$color = 'warna_kecamatan';

		  		$lokasi = 'BatasKab';

		  		$json = 'geojson_kecamatan';

		  	}

		  	else{

		  		if($desa=='semua'){

		  			$db->where("kecamatan",$kecamatan);

						$getdata=$db->ObjectBuilder()->get('m_kecamatan');

						$nama = 'kecamatan';

						$color = 'warna_kecamatan';

						$lokasi = 'BatasKab';

						$json = 'geojson_kecamatan';

		  		}else{

		  			$db->where("kecamatan",$kecamatan);

		  			$db->where("nama_desa",$desa);

						$getdata=$db->ObjectBuilder()->get('m_desa');

						$nama = 'nama_desa';

						$color = 'warna_desa';

						$lokasi = 'BatasDesa';

						$json = 'geojson_desa';

		  		}		  		

		  	}

		  	foreach ($getdata as $row) {

		?>



		  	var myStyle<?=$row->id?> = {

			    "color": "<?=$row->$color?>",

			    "weight": 3,

			    "opacity": 2

				};

		<?php

						$arrayKec[]='{

						name: "'.$row->$nama.'",

						icon: iconByName("'.$row->$color.'"),

						layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$lokasi.'/'.$row->$json.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

						}';

					}



			break;





			case "sawah":

		  	if($kecamatan=='semua'){

		  		$getdata=$db->ObjectBuilder()->get('peta_sawah');

		  		$nama = 'kecamatan';

		  		$color = 'warna_sawah';

		  		$lokasi = 'Sawah';

		  		$json = 'geojson_sawah';

		  	}

		  	else{

		  		$db->where("kecamatan",$kecamatan);

					$getdata=$db->ObjectBuilder()->get('peta_sawah');

					$nama = 'kecamatan';

					$color = 'warna_sawah';

					$lokasi = 'Sawah';

					$json = 'geojson_sawah';

		  	}

		  	foreach ($getdata as $row) {

		?>



		  	var myStyle<?=$row->id?> = {

			    "color": "<?=$row->$color?>",

			    "weight": 3,

			    "opacity": 2

				};

		<?php

						$arrayKec[]='{

						name: "'.$row->$nama.'",

						icon: iconByName("'.$row->$color.'"),

						layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$lokasi.'/'.$row->$json.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

						}';

					}



			break;





			case "irigasi":

		  	if($kecamatan=='semua'){

		  		$getdata=$db->ObjectBuilder()->get('peta_irigasi');

		  		$nama = 'kecamatan';

		  		$color = 'warna_irigasi';

		  		$lokasi = 'BatasIrigasi';

		  		$json = 'geojson_irigasi';

		  	}

		  	else{

		  		if($desa=='semua'){

		  			$db->where("kecamatan",$kecamatan);

						$getdata=$db->ObjectBuilder()->get('peta_irigasi_desa');

						$nama = 'nama_desa';

						$color = 'warna_desa';

						$lokasi = 'DesaIrigasi';

						$json = 'geojson_desa';

		  		}else{

		  			$db->where("kecamatan",$kecamatan);

		  			$db->where("nama_desa",$desa);

						$getdata=$db->ObjectBuilder()->get('peta_irigasi_desa');

						$nama = 'nama_desa';

						$color = 'warna_desa';

						$lokasi = 'DesaIrigasi';

						$json = 'geojson_desa';

		  		}

		  	}

		  	foreach ($getdata as $row) {

		?>



		  	var myStyle<?=$row->id?> = {

			    "color": "<?=$row->$color?>",

			    "weight": 3,

			    "opacity": 2

				};

		<?php

						$arrayKec[]='{

						name: "'.$row->$nama.'",

						icon: iconByName("'.$row->$color.'"),

						layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$lokasi.'/'.$row->$json.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

						}';

					}



			break;





			case "jutani":

		  	if($kecamatan=='semua'){

		  		$getdata=$db->ObjectBuilder()->get('peta_jut');

		  		$nama = 'kecamatan';

		  		$color = 'warna_jut';

		  		$lokasi = 'JalanUsahaTani';

		  		$json = 'geojson_jut';

		  	}

		  	else{

		  		$db->where("kecamatan",$kecamatan);

					$getdata=$db->ObjectBuilder()->get('peta_jut');

					$nama = 'kecamatan';

					$color = 'warna_jut';

					$lokasi = 'JalanUsahaTani';

					$json = 'geojson_jut';

		  	}

		  	foreach ($getdata as $row) {

		?>



		  	var myStyle<?=$row->id?> = {

			    "color": "<?=$row->$color?>",

			    "weight": 3,

			    "opacity": 2

				};

		<?php

						$arrayKec[]='{

						name: "'.$row->$nama.'",

						icon: iconByName("'.$row->$color.'"),

						layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/'.$lokasi.'/'.$row->$json.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

						}';

					}



			break;





			default:

				$getdata=$db->ObjectBuilder()->get('m_kecamatan');

				foreach ($getdata as $row) {

					?>



					var myStyle<?=$row->id?> = {

					    "color": "<?=$row->warna_kecamatan?>",

					    "weight": 3,

					    "opacity": 2

					};



					<?php

					$arrayKec[]='{

					name: "'.$row->kecamatan.'",

					icon: iconByName("'.$row->warna_kecamatan.'"),

					layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/BatasKab/'.$row->geojson_kecamatan.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

					}';

				}

		

		}	

	

	?>



	

	var overLayers = [

		{

			group: "Batas Administrasi",

			layers: [

				<?=implode(',', $arrayKec);?>

			]	

		}

	];



	

	var panelLayers = new L.Control.PanelLayers(baseLayers, overLayers,{

		position:'topleft',

		selectorGroup: true,

		collapsibleGroups: true

	});



	map.addControl(panelLayers);

	// map.addControl( new L.Control.Compass({

	// 	position:'topleft',

	// 	autoActive:true,

	// 	showDigit:true

	// }) );







   </script>

