/*!

* dependencyLibs/inputmask.dependencyLib.jqlite.js

* https://github.com/RobinHerbots/Inputmask

* Copyright (c) 2010 - 2017 Robin Herbots

* Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)

* Version: 3.3.11

*/



!function(factory) {

    "function" == typeof define && define.amd ? define([ "jqlite", "../global/window", "../global/document]" ], factory) : "object" == typeof exports ? module.exports = factory(require("jqlite"), require("../global/window"), require("../global/document")) : window.dependencyLib = factory(jqlite, window, document);

}(function($, window, document) {

    function indexOf(list, elem) {

        for (var i = 0, len = list.length; i < len; i++) if (list[i] === elem) return i;

        return -1;

    }

    function type(obj) {

        return null == obj ? obj + "" : "object" == typeof obj || "function" == typeof obj ? class2type[class2type.toString.call(obj)] || "object" : typeof obj;

    }

    function isWindow(obj) {

        return null != obj && obj === obj.window;

    }

    function isArraylike(obj) {

        var length = "length" in obj && obj.length, ltype = type(obj);

        return "function" !== ltype && !isWindow(obj) && (!(1 !== obj.nodeType || !length) || ("array" === ltype || 0 === length || "number" == typeof length && length > 0 && length - 1 in obj));

    }

    for (var class2type = {}, classTypes = "Boolean Number String Function Array Date RegExp Object Error".split(" "), nameNdx = 0; nameNdx < classTypes.length; nameNdx++) class2type["[object " + classTypes[nameNdx] + "]"] = classTypes[nameNdx].toLowerCase();

    return $.inArray = function(elem, arr, i) {

        return null == arr ? -1 : indexOf(arr, elem);

    }, $.isFunction = function(obj) {

        return "function" === type(obj);

    }, $.isArray = Array.isArray, $.isPlainObject = function(obj) {

        return "object" === type(obj) && !obj.nodeType && !isWindow(obj) && !(obj.constructor && !class2type.hasOwnProperty.call(obj.constructor.prototype, "isPrototypeOf"));

    }, $.extend = function() {

        var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = !1;

        for ("boolean" == typeof target && (deep = target, target = arguments[i] || {}, 

        i++), "object" == typeof target || $.isFunction(target) || (target = {}), i === length && (target = this, 

        i--); i < length; i++) if (null != (options = arguments[i])) for (name in options) src = target[name], 

        target !== (copy = options[name]) && (deep && copy && ($.isPlainObject(copy) || (copyIsArray = $.isArray(copy))) ? (copyIsArray ? (copyIsArray = !1, 

        clone = src && $.isArray(src) ? src : []) : clone = src && $.isPlainObject(src) ? src : {}, 

        target[name] = $.extend(deep, clone, copy)) : void 0 !== copy && (target[name] = copy));

        return target;

    }, $.each = function(obj, callback) {

        var i = 0;

        if (isArraylike(obj)) for (var length = obj.length; i < length && !1 !== callback.call(obj[i], i, obj[i]); i++) ; else for (i in obj) if (!1 === callback.call(obj[i], i, obj[i])) break;

        return obj;

    }, $.map = function(elems, callback) {

        var value, i = 0, length = elems.length, ret = [];

        if (isArraylike(elems)) for (;i < length; i++) null != (value = callback(elems[i], i)) && ret.push(value); else for (i in elems) null != (value = callback(elems[i], i)) && ret.push(value);

        return [].concat(ret);

    }, $.data = function(elem, name, data) {

        return $(elem).data(name, data);

    }, $.Event = $.Event || function(event, params) {

        params = params || {

            bubbles: !1,

            cancelable: !1,

            detail: void 0

        };

        var evt = document.createEvent("CustomEvent");

        return evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail), 

        evt;

    }, $.Event.prototype = window.Event.prototype, $;

});