define( [

	"../core"

], function( jQuery ) {



"use strict";



// Cross-browser xml parsing

jQuery.parseXML = function( data ) {

	var xml;

	if ( !data || typeof data !== "string" ) {

		return null;

	}



	// Support: IE 9 - 11 only

	// IE throws on parseFromString with invalid input.

	try {

		xml = ( new window.DOMParser() ).parseFromString( data, "text/xml" );

	} catch ( e ) {

		xml = undefined;

	}



	if ( !xml || xml.getElementsByTagName( "parsererror" ).length ) {

		jQuery.error( "Invalid XML: " + data );

	}

	return xml;

};



return jQuery.parseXML;



} );

