/**

 * Basic wrapper for DOM element.

 * @constructor

 * @param {String} name Tag name of the element

 * @param {Object} config Set of parameters to initialize element with

 */

jvm.AbstractElement = function(name, config){

  /**

   * Underlying DOM element

   * @type {DOMElement}

   * @private

   */

  this.node = this.createElement(name);



  /**

   * Name of underlying element

   * @type {String}

   * @private

   */

  this.name = name;



  /**

   * Internal store of attributes

   * @type {Object}

   * @private

   */

  this.properties = {};



  if (config) {

    this.set(config);

  }

};



/**

 * Set attribute of the underlying DOM element.

 * @param {String} name Name of attribute

 * @param {Number|String} config Set of parameters to initialize element with

 */

jvm.AbstractElement.prototype.set = function(property, value){

  var key;



  if (typeof property === 'object') {

    for (key in property) {

      this.properties[key] = property[key];

      this.applyAttr(key, property[key]);

    }

  } else {

    this.properties[property] = value;

    this.applyAttr(property, value);

  }

};



/**

 * Returns value of attribute.

 * @param {String} name Name of attribute

 */

jvm.AbstractElement.prototype.get = function(property){

  return this.properties[property];

};



/**

 * Applies attribute value to the underlying DOM element.

 * @param {String} name Name of attribute

 * @param {Number|String} config Value of attribute to apply

 * @private

 */

jvm.AbstractElement.prototype.applyAttr = function(property, value){

  this.node.setAttribute(property, value);

};



jvm.AbstractElement.prototype.remove = function(){

  jvm.$(this.node).remove();

};