jvm.VMLShapeElement = function(name, config){

  jvm.VMLShapeElement.parentClass.call(this, name, config);



  this.fillElement = new jvm.VMLElement('fill');

  this.strokeElement = new jvm.VMLElement('stroke');

  this.node.appendChild(this.fillElement.node);

  this.node.appendChild(this.strokeElement.node);

  this.node.stroked = false;



  jvm.AbstractShapeElement.apply(this, arguments);

};



jvm.inherits(jvm.VMLShapeElement, jvm.VMLElement);

jvm.mixin(jvm.VMLShapeElement, jvm.AbstractShapeElement);



jvm.VMLShapeElement.prototype.applyAttr = function(attr, value){

  switch (attr) {

    case 'fill':

      this.node.fillcolor = value;

      break;

    case 'fill-opacity':

      this.fillElement.node.opacity = Math.round(value*100)+'%';

      break;

    case 'stroke':

      if (value === 'none') {

        this.node.stroked = false;

      } else {

        this.node.stroked = true;

      }

      this.node.strokecolor = value;

      break;

    case 'stroke-opacity':

      this.strokeElement.node.opacity = Math.round(value*100)+'%';

      break;

    case 'stroke-width':

      if (parseInt(value, 10) === 0) {

        this.node.stroked = false;

      } else {

        this.node.stroked = true;

      }

      this.node.strokeweight = value;

      break;

    case 'd':

      this.node.path = jvm.VMLPathElement.pathSvgToVml(value);

      break;

    default:

      jvm.VMLShapeElement.parentClass.prototype.applyAttr.apply(this, arguments);

  }

};