export var defaultLongDateFormat = {

    LTS  : 'h:mm:ss A',

    LT   : 'h:mm A',

    L    : 'MM/DD/YYYY',

    LL   : 'MMMM D, YYYY',

    LLL  : 'MMMM D, YYYY h:mm A',

    LLLL : 'dddd, MMMM D, YYYY h:mm A'

};



export function longDateFormat (key) {

    var format = this._longDateFormat[key],

        formatUpper = this._longDateFormat[key.toUpperCase()];



    if (format || !formatUpper) {

        return format;

    }



    this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {

        return val.slice(1);

    });



    return this._longDateFormat[key];

}

