//! moment.js locale configuration

//! locale : Nepalese [ne]

//! author : suvash : https://github.com/suvash



import moment from '../moment';



var symbolMap = {

    '1': '१',

    '2': '२',

    '3': '३',

    '4': '४',

    '5': '५',

    '6': '६',

    '7': '७',

    '8': '८',

    '9': '९',

    '0': '०'

},

numberMap = {

    '१': '1',

    '२': '2',

    '३': '3',

    '४': '4',

    '५': '5',

    '६': '6',

    '७': '7',

    '८': '8',

    '९': '9',

    '०': '0'

};



export default moment.defineLocale('ne', {

    months : 'जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर'.split('_'),

    monthsShort : 'जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.'.split('_'),

    monthsParseExact : true,

    weekdays : 'आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार'.split('_'),

    weekdaysShort : 'आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.'.split('_'),

    weekdaysMin : 'आ._सो._मं._बु._बि._शु._श.'.split('_'),

    weekdaysParseExact : true,

    longDateFormat : {

        LT : 'Aको h:mm बजे',

        LTS : 'Aको h:mm:ss बजे',

        L : 'DD/MM/YYYY',

        LL : 'D MMMM YYYY',

        LLL : 'D MMMM YYYY, Aको h:mm बजे',

        LLLL : 'dddd, D MMMM YYYY, Aको h:mm बजे'

    },

    preparse: function (string) {

        return string.replace(/[१२३४५६७८९०]/g, function (match) {

            return numberMap[match];

        });

    },

    postformat: function (string) {

        return string.replace(/\d/g, function (match) {

            return symbolMap[match];

        });

    },

    meridiemParse: /राति|बिहान|दिउँसो|साँझ/,

    meridiemHour : function (hour, meridiem) {

        if (hour === 12) {

            hour = 0;

        }

        if (meridiem === 'राति') {

            return hour < 4 ? hour : hour + 12;

        } else if (meridiem === 'बिहान') {

            return hour;

        } else if (meridiem === 'दिउँसो') {

            return hour >= 10 ? hour : hour + 12;

        } else if (meridiem === 'साँझ') {

            return hour + 12;

        }

    },

    meridiem : function (hour, minute, isLower) {

        if (hour < 3) {

            return 'राति';

        } else if (hour < 12) {

            return 'बिहान';

        } else if (hour < 16) {

            return 'दिउँसो';

        } else if (hour < 20) {

            return 'साँझ';

        } else {

            return 'राति';

        }

    },

    calendar : {

        sameDay : '[आज] LT',

        nextDay : '[भोलि] LT',

        nextWeek : '[आउँदो] dddd[,] LT',

        lastDay : '[हिजो] LT',

        lastWeek : '[गएको] dddd[,] LT',

        sameElse : 'L'

    },

    relativeTime : {

        future : '%sमा',

        past : '%s अगाडि',

        s : 'केही क्षण',

        ss : '%d सेकेण्ड',

        m : 'एक मिनेट',

        mm : '%d मिनेट',

        h : 'एक घण्टा',

        hh : '%d घण्टा',

        d : 'एक दिन',

        dd : '%d दिन',

        M : 'एक महिना',

        MM : '%d महिना',

        y : 'एक बर्ष',

        yy : '%d बर्ष'

    },

    week : {

        dow : 0, // Sunday is the first day of the week.

        doy : 6  // The week that contains Jan 6th is the first week of the year.

    }

});



