

<!-- Make sure you put this AFTER Leaflet's CSS -->

 <script src="https://unpkg.com/leaflet@1.3.4/dist/leaflet.js" integrity="sha512-nMMmRyTVoLYqjP9hrbed9S+FzjZHW5gY1TWCHA5ckwXZBadntCNs8kEqAWdrb9O7rxbCaA4lKTIWjDXZxflOcA=="

   crossorigin=""></script>

 <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCHqhgVQmhdp3XAJ91LHRdXJ3YOjP1V2Gs" async defer></script>

 <script src="assets/js/leaflet-panel-layers-master/src/leaflet-panel-layers.js"></script>

 <script src="assets/js/leaflet.ajax.js"></script>

 <script src="assets/js/Leaflet.GoogleMutant.js"></script>



 <script type="text/javascript">



   	<?php

   			if ($session->get('level')=='Admin' OR $session->get('level')=='User'){

   				$lat = "3.2304447";

   				$long = "99.315189";

   				$zoom = 11;

				}else {

					$db->where("kecamatan",$session->get('lokasi'));

					$data=$db->ObjectBuilder()->getOne('m_kecamatan');

					if($db->count>0){

						$lat = $data->latitude;

	   				$long = $data->longitude;

	   				$zoom = $data->zoom;

					}					

				}

   	?>



		var map = L.map('mapid').setView([<?=$lat?>,<?=$long?>], <?=$zoom?>);

		map.zoomControl.setPosition('topright');



    var LayerKita = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {

          maxZoom: 19,

          attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'

    });

    var roadMutant = L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'roadmap'

		});

	map.addLayer(LayerKita);


	function popUp(f,l){

	    var out = [];

	    if (f.properties){

	    		for(key in f.properties){

              out.push(key+": "+f.properties[key]);

          }

          l.bindPopup(out.join("<br />"));

	    }

	}

	// legend



	function iconByName(name) {

		return '<i class="icon" style="background-color:'+name+';border-radius:50%"></i>';

	}



	function featureToMarker(feature, latlng) {

		return L.marker(latlng, {

			icon: L.divIcon({

				className: 'marker-'+feature.properties.amenity,

				html: iconByName(feature.properties.amenity),

				iconUrl: '../images/markers/'+feature.properties.amenity+'.png',

				iconSize: [25, 41],

				iconAnchor: [12, 41],

				popupAnchor: [1, -34],

				shadowSize: [41, 41]

			})

		});

	}



	var baseLayers = [

		{

			name: "OpenStreetMap",

			layer: LayerKita

		},

		{

			name: "OpenCycleMap",

			layer: L.tileLayer('http://{s}.tile.opencyclemap.org/cycle/{z}/{x}/{y}.png')

		},

		{

			name: "Outdoors",

			layer: L.tileLayer('http://{s}.tile.thunderforest.com/outdoors/{z}/{x}/{y}.png')

		},

		{

			name:'Satelite Google',

			layer : L.gridLayer.googleMutant({

				maxZoom: 24,

				type:'satellite'

			})

		},

		{

			name: "Roadmap Google",

			layer: roadMutant

		}

	];



	<?php

		if ($session->get('level')=='Admin' OR $session->get('level')=='User'){

			$getSawah=$db->ObjectBuilder()->get('peta_sawah');

			// $getdata=$dbs->ObjectBuilder()->get('sawah');

		}elseif ($session->get('level')=='Kecamatan') {

			$db->where("kecamatan",$session->get('lokasi'));

			$getSawah=$db->ObjectBuilder()->get('peta_sawah');

			// $dbs->where("kecamatan",$session->get('lokasi'));

			// $getdata=$dbs->ObjectBuilder()->get('sawah');

		}

		foreach ($getSawah as $row) {

				// foreach ($getdata as $rows) {

			?>



					var myStyle<?=$row->id?> = {

					    "color": "<?=$row->warna_sawah?>",

					    "weight": 3,

					    "opacity": 2

					};





					<?php

					$arrayIrigasi[]='{

					name: "'.$row->kecamatan.'",

					icon: iconByName("'.$row->warna_sawah.'"),

					layer: new L.GeoJSON.AJAX(["assets/unggah/geojson/Sawah/'.$row->geojson_sawah.'"],{onEachFeature:popUp,style: myStyle'.$row->id.',pointToLayer: featureToMarker }).addTo(map)

					}';

				// }

		}

	?>

	<?php

		if($session->get('lokasi')==''){

			$lokasi = "Kab. Batu Bara";

		}else{

			$lokasi = "Kec. ".$session->get('lokasi');

		}

	?>



	var overLayers = [{

		group: "Garis JUT <?=$lokasi?>",

		layers: [

			<?=implode(',', $arrayIrigasi);?>

		]

	}

	];

	

	var panelLayers = new L.Control.PanelLayers(baseLayers, overLayers,{

		collapsibleGroups: true,

		position:'topleft'

	});



	map.addControl(panelLayers);

	// map.addControl( new L.Control.Compass({

	// 	position:'topleft',

	// 	autoActive:true,

	// 	showDigit:true

	// }) );







   </script>

