/**

 * Leaflet Panel Layers v1.2.4 - 2018-10-08

 *

 * Copyright 2018 Stefano Cudini

 * stefano.cudini@gmail.com

 * http://labs.easyblog.it/

 *

 * Licensed under the MIT license.

 *

 * Demos:

 * http://labs.easyblog.it/maps/leaflet-panel-layers/

 *

 * Source:

 * git@github.com:stefanocudini/leaflet-panel-layers.git

 *

 */

!function(a){if("function"==typeof define&&define.amd)define(["leaflet"],a);else if("undefined"!=typeof module)module.exports=a(require("leaflet"));else{if("undefined"==typeof window.L)throw"Leaflet must be loaded first";a(window.L)}}(function(a){return a.Control.PanelLayers=a.Control.Layers.extend({includes:"1"===a.version[0]?a.Evented.prototype:a.Mixin.Events,options:{compact:!1,compactOffset:0,collapsed:!1,autoZIndex:!0,collapsibleGroups:!1,buildItem:null,title:"",className:"",position:"topright"},initialize:function(b,c,d){a.setOptions(this,d),this._layers=[],this._groups={},this._items={},this._layersActives=[],this._lastZIndex=0,this._handlingClick=!1,this.className="leaflet-panel-layers";var e,f,g;for(e in b)if(b[e].group&&b[e].layers){g=b[e].collapsed||!1;for(f in b[e].layers)this._addLayer(b[e].layers[f],!1,b[e].group,g)}else this._addLayer(b[e],!1);for(e in c)if(c[e].group&&c[e].layers){g=c[e].collapsed||!1;for(f in c[e].layers)this._addLayer(c[e].layers[f],!0,c[e].group,g)}else this._addLayer(c[e],!0)},onAdd:function(b){var c=this;for(var d in this._layersActives)b.addLayer(this._layersActives[d]);return a.Control.Layers.prototype.onAdd.call(this,b),this._map.on("resize",function(a){c._updateHeight(a.newSize.y)}),this._container},addBaseLayer:function(a,b,c){return a.name=b||a.name||"",this._addLayer(a,!1,c),this._update(),this},addOverlay:function(a,b,c){return a.name=b||a.name||"",this._addLayer(a,!0,c),this._update(),this},removeLayer:function(b){var c=b.hasOwnProperty("layer")?this._layerFromDef(b):b;return this._map.removeLayer(c),a.Control.Layers.prototype.removeLayer.call(this,c),this},clearLayers:function(){for(var a=0;a<this._layers.length;a++)this.removeLayer(this._layers[a])},_layerFromDef:function(b){for(var c=0;c<this._layers.length;c++){var d=a.stamp(this._layers[c].layer);if(this._getLayer(d).name===b.name)return this._getLayer(d).layer}},_update:function(){this._groups={},this._items={},a.Control.Layers.prototype._update.call(this)},_getLayer:function(a){for(var b=0;b<this._layers.length;b++)if(this._layers[b]&&this._layers[b].id==a)return this._layers[b]},_addLayer:function(b,c,d,e){if(!b.layer)throw new Error("layer not defined in item: "+(b.name||""));b.layer instanceof a.Class||!b.layer.type||!b.layer.args||(b.layer=this._getPath(a,b.layer.type).apply(a,b.layer.args)),b.hasOwnProperty("id")||(b.id=a.stamp(b.layer)),b.active&&this._layersActives.push(b.layer),this._layers.push(a.Util.extend(b,{collapsed:e,overlay:c,group:d})),this.options.autoZIndex&&b.layer&&b.layer.setZIndex&&(this._lastZIndex++,b.layer.setZIndex(this._lastZIndex))},_createItem:function(b){var c,d,e,f=this;c=a.DomUtil.create("div",this.className+"-item"+(b.active?" active":"")),e=this._map.hasLayer(b.layer),b.overlay?(d=a.DomUtil.create("input",this.className+"-selector"),d.type="checkbox",d.defaultChecked=e):d=this._createRadioElement("leaflet-base-layers",e,b),d.value=b.id,d.layerId=b.id,d.id=b.id,d._layer=b,a.DomEvent.on(d,"click",function(a){f._onInputClick(),a.target.checked?f.fire("panel:selected",a.target._layer):f.fire("panel:unselected",a.target._layer)},this);var g=a.DomUtil.create("label",this.className+"-title"),h=a.DomUtil.create("span");if(h.innerHTML=b.name||"",b.icon){var i=a.DomUtil.create("i",this.className+"-icon");"string"==typeof b.icon?i.innerHTML=b.icon||"":i.appendChild(b.icon),g.appendChild(i)}if(g.appendChild(d),g.appendChild(h),c.appendChild(g),this.options.buildItem){var j=this.options.buildItem.call(this,b);if("string"==typeof j){var k=a.DomUtil.create("div");k.innerHTML=j,c.appendChild(k.firstChild)}else c.appendChild(j)}return this._items[d.value]=c,c},_createRadioElement:function(a,b,c){var d='<input type="radio" class="'+this.className+'-selector" name="'+a+'" id="'+c.id+'"';b&&(d+=' checked="checked"'),d+=" />";var e=document.createElement("div");return e.innerHTML=d,e.firstChild},_addItem:function(a){var b,c=a.overlay?this._overlaysList:this._baseLayersList;if(a.group){if(a.group.hasOwnProperty("name")||(a.group={name:a.group}),!this._groups[a.group.name]){var d=!1;a.collapsed===!0&&(d=!0),this._groups[a.group.name]=this._createGroup(a.group,d)}c.appendChild(this._groups[a.group.name]),c=this._groups[a.group.name]}return b=this._createItem(a),c.appendChild(b),b},_createGroup:function(b,c){var d,e,f,g=this,h=a.DomUtil.create("div",this.className+"-group");return this.options.collapsibleGroups&&(a.DomUtil.addClass(h,"collapsible"),f=a.DomUtil.create("i",this.className+"-icon",h),c===!0?f.innerHTML=" + ":f.innerHTML=" - ",a.DomEvent.on(f,"click",function(){a.DomUtil.hasClass(h,"expanded")?(a.DomUtil.removeClass(h,"expanded"),f.innerHTML=" + "):(a.DomUtil.addClass(h,"expanded"),f.innerHTML=" - "),g._updateHeight()}),c===!1&&a.DomUtil.addClass(h,"expanded")),d=a.DomUtil.create("label",this.className+"-grouplabel",h),e=a.DomUtil.create("span",this.className+"-title",d),e.innerHTML=b.name,h},_onInputClick:function(){var b,c,d,e=this._form.getElementsByClassName(this.className+"-selector"),f=e.length;for(this._handlingClick=!0,b=0;f>b;b++)c=e[b],d=this._getLayer(c.value),c.checked&&!this._map.hasLayer(d.layer)?(a.DomUtil.addClass(c.parentNode.parentNode,"active"),this._map.addLayer(d.layer)):!c.checked&&this._map.hasLayer(d.layer)&&(a.DomUtil.removeClass(c.parentNode.parentNode,"active"),this._map.removeLayer(d.layer));this._handlingClick=!1,this._refocusOnMap()},_initLayout:function(){var b=this._container=a.DomUtil.create("div",this.className);if(this.options.compact&&a.DomUtil.addClass(b,"compact"),b.setAttribute("aria-haspopup",!0),a.DomEvent.disableClickPropagation(b).disableScrollPropagation(b),this.options.className&&a.DomUtil.addClass(b,this.options.className),this._form=a.DomUtil.create("form",this.className+"-list"),this._updateHeight(),this.options.collapsed?(a.Browser.android?a.DomEvent.on(b,"click",this._expand,this):a.DomEvent.on(b,"mouseenter",this._expand,this).on(b,"mouseleave",this._collapse,this),this._map.on("click",this._collapse,this)):this._expand(),this._baseLayersList=a.DomUtil.create("div",this.className+"-base",this._form),this._separator=a.DomUtil.create("div",this.className+"-separator",this._form),this._overlaysList=a.DomUtil.create("div",this.className+"-overlays",this._form),this.options.title){var c=a.DomUtil.create("label",this.className+"-title");c.innerHTML="<span>"+this.options.title+"</span>",b.appendChild(c)}b.appendChild(this._form)},_updateHeight:function(a){a=a||this._map.getSize().y,this.options.compact?this._form.style.maxHeight=a-this.options.compactOffset+"px":this._form.style.height=a+"px"},_expand:function(){a.DomUtil.addClass(this._container,"expanded")},_collapse:function(){this._container.className=this._container.className.replace("expanded","")},_getPath:function(a,b){var c=b.split("."),d=c.pop(),e=c.length,f=c[0],g=1;if(e>0)for(;(a=a[f])&&e>g;)f=c[g++];return a?a[d]:void 0}}),a.control.panelLayers=function(b,c,d){return new a.Control.PanelLayers(b,c,d)},a.Control.PanelLayers});