var map = L.map('map');



L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {

	attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors'

}).addTo(map);



var control = L.Routing.control({

	waypoints: [

		L.latLng(57.74, 11.94),

		L.latLng(57.6792, 11.949)

	],

	geocoder: L.Control.Geocoder.nominatim(),

	routeWhileDragging: true,

	reverseWaypoints: true,

	showAlternatives: true,

	altLineOptions: {

		styles: [

			{color: 'black', opacity: 0.15, weight: 9},

			{color: 'white', opacity: 0.8, weight: 6},

			{color: 'blue', opacity: 0.5, weight: 2}

		]

	},

	router: L.Routing.mapbox('your-token-here')

}).addTo(map);



L.Routing.errorControl(control).addTo(map);