/*!

* dependencyLibs/inputmask.dependencyLib.js

* https://github.com/RobinHerbots/Inputmask

* Copyright (c) 2010 - 2017 Robin Herbots

* Licensed under the MIT license (http://www.opensource.org/licenses/mit-license.php)

* Version: 3.3.11

*/



!function(factory) {

    "function" == typeof define && define.amd ? define([ "../global/window", "../global/document" ], factory) : "object" == typeof exports ? module.exports = factory(require("../global/window"), require("../global/document")) : window.dependencyLib = factory(window, document);

}(function(window, document) {

    function indexOf(list, elem) {

        for (var i = 0, len = list.length; i < len; i++) if (list[i] === elem) return i;

        return -1;

    }

    function type(obj) {

        return null == obj ? obj + "" : "object" == typeof obj || "function" == typeof obj ? class2type[class2type.toString.call(obj)] || "object" : typeof obj;

    }

    function isWindow(obj) {

        return null != obj && obj === obj.window;

    }

    function isArraylike(obj) {

        var length = "length" in obj && obj.length, ltype = type(obj);

        return "function" !== ltype && !isWindow(obj) && (!(1 !== obj.nodeType || !length) || ("array" === ltype || 0 === length || "number" == typeof length && length > 0 && length - 1 in obj));

    }

    function isValidElement(elem) {

        return elem instanceof Element;

    }

    function DependencyLib(elem) {

        return elem instanceof DependencyLib ? elem : this instanceof DependencyLib ? void (void 0 !== elem && null !== elem && elem !== window && (this[0] = elem.nodeName ? elem : void 0 !== elem[0] && elem[0].nodeName ? elem[0] : document.querySelector(elem), 

        void 0 !== this[0] && null !== this[0] && (this[0].eventRegistry = this[0].eventRegistry || {}))) : new DependencyLib(elem);

    }

    for (var class2type = {}, classTypes = "Boolean Number String Function Array Date RegExp Object Error".split(" "), nameNdx = 0; nameNdx < classTypes.length; nameNdx++) class2type["[object " + classTypes[nameNdx] + "]"] = classTypes[nameNdx].toLowerCase();

    return DependencyLib.prototype = {

        on: function(events, handler) {

            if (isValidElement(this[0])) for (var eventRegistry = this[0].eventRegistry, elem = this[0], _events = events.split(" "), endx = 0; endx < _events.length; endx++) {

                var nsEvent = _events[endx].split(".");

                !function(ev, namespace) {

                    elem.addEventListener ? elem.addEventListener(ev, handler, !1) : elem.attachEvent && elem.attachEvent("on" + ev, handler), 

                    eventRegistry[ev] = eventRegistry[ev] || {}, eventRegistry[ev][namespace] = eventRegistry[ev][namespace] || [], 

                    eventRegistry[ev][namespace].push(handler);

                }(nsEvent[0], nsEvent[1] || "global");

            }

            return this;

        },

        off: function(events, handler) {

            if (isValidElement(this[0])) for (var eventRegistry = this[0].eventRegistry, elem = this[0], _events = events.split(" "), endx = 0; endx < _events.length; endx++) for (var nsEvent = _events[endx].split("."), offEvents = function(ev, namespace) {

                var hndx, hndL, evts = [];

                if (ev.length > 0) if (void 0 === handler) for (hndx = 0, hndL = eventRegistry[ev][namespace].length; hndx < hndL; hndx++) evts.push({

                    ev: ev,

                    namespace: namespace && namespace.length > 0 ? namespace : "global",

                    handler: eventRegistry[ev][namespace][hndx]

                }); else evts.push({

                    ev: ev,

                    namespace: namespace && namespace.length > 0 ? namespace : "global",

                    handler: handler

                }); else if (namespace.length > 0) for (var evNdx in eventRegistry) for (var nmsp in eventRegistry[evNdx]) if (nmsp === namespace) if (void 0 === handler) for (hndx = 0, 

                hndL = eventRegistry[evNdx][nmsp].length; hndx < hndL; hndx++) evts.push({

                    ev: evNdx,

                    namespace: nmsp,

                    handler: eventRegistry[evNdx][nmsp][hndx]

                }); else evts.push({

                    ev: evNdx,

                    namespace: nmsp,

                    handler: handler

                });

                return evts;

            }(nsEvent[0], nsEvent[1]), i = 0, offEventsL = offEvents.length; i < offEventsL; i++) !function(ev, namespace, handler) {

                if (ev in eventRegistry == 1) if (elem.removeEventListener ? elem.removeEventListener(ev, handler, !1) : elem.detachEvent && elem.detachEvent("on" + ev, handler), 

                "global" === namespace) for (var nmsp in eventRegistry[ev]) eventRegistry[ev][nmsp].splice(eventRegistry[ev][nmsp].indexOf(handler), 1); else eventRegistry[ev][namespace].splice(eventRegistry[ev][namespace].indexOf(handler), 1);

            }(offEvents[i].ev, offEvents[i].namespace, offEvents[i].handler);

            return this;

        },

        trigger: function(events) {

            if (isValidElement(this[0])) for (var eventRegistry = this[0].eventRegistry, elem = this[0], _events = "string" == typeof events ? events.split(" ") : [ events.type ], endx = 0; endx < _events.length; endx++) {

                var nsEvent = _events[endx].split("."), ev = nsEvent[0], namespace = nsEvent[1] || "global";

                if (void 0 !== document && "global" === namespace) {

                    var evnt, i, params = {

                        bubbles: !0,

                        cancelable: !0,

                        detail: Array.prototype.slice.call(arguments, 1)

                    };

                    if (document.createEvent) {

                        try {

                            evnt = new CustomEvent(ev, params);

                        } catch (e) {

                            (evnt = document.createEvent("CustomEvent")).initCustomEvent(ev, params.bubbles, params.cancelable, params.detail);

                        }

                        events.type && DependencyLib.extend(evnt, events), elem.dispatchEvent(evnt);

                    } else (evnt = document.createEventObject()).eventType = ev, events.type && DependencyLib.extend(evnt, events), 

                    elem.fireEvent("on" + evnt.eventType, evnt);

                } else if (void 0 !== eventRegistry[ev]) if (arguments[0] = arguments[0].type ? arguments[0] : DependencyLib.Event(arguments[0]), 

                "global" === namespace) for (var nmsp in eventRegistry[ev]) for (i = 0; i < eventRegistry[ev][nmsp].length; i++) eventRegistry[ev][nmsp][i].apply(elem, arguments); else for (i = 0; i < eventRegistry[ev][namespace].length; i++) eventRegistry[ev][namespace][i].apply(elem, arguments);

            }

            return this;

        }

    }, DependencyLib.isFunction = function(obj) {

        return "function" === type(obj);

    }, DependencyLib.noop = function() {}, DependencyLib.isArray = Array.isArray, DependencyLib.inArray = function(elem, arr, i) {

        return null == arr ? -1 : indexOf(arr, elem);

    }, DependencyLib.valHooks = void 0, DependencyLib.isPlainObject = function(obj) {

        return "object" === type(obj) && !obj.nodeType && !isWindow(obj) && !(obj.constructor && !class2type.hasOwnProperty.call(obj.constructor.prototype, "isPrototypeOf"));

    }, DependencyLib.extend = function() {

        var options, name, src, copy, copyIsArray, clone, target = arguments[0] || {}, i = 1, length = arguments.length, deep = !1;

        for ("boolean" == typeof target && (deep = target, target = arguments[i] || {}, 

        i++), "object" == typeof target || DependencyLib.isFunction(target) || (target = {}), 

        i === length && (target = this, i--); i < length; i++) if (null != (options = arguments[i])) for (name in options) src = target[name], 

        target !== (copy = options[name]) && (deep && copy && (DependencyLib.isPlainObject(copy) || (copyIsArray = DependencyLib.isArray(copy))) ? (copyIsArray ? (copyIsArray = !1, 

        clone = src && DependencyLib.isArray(src) ? src : []) : clone = src && DependencyLib.isPlainObject(src) ? src : {}, 

        target[name] = DependencyLib.extend(deep, clone, copy)) : void 0 !== copy && (target[name] = copy));

        return target;

    }, DependencyLib.each = function(obj, callback) {

        var i = 0;

        if (isArraylike(obj)) for (var length = obj.length; i < length && !1 !== callback.call(obj[i], i, obj[i]); i++) ; else for (i in obj) if (!1 === callback.call(obj[i], i, obj[i])) break;

        return obj;

    }, DependencyLib.map = function(elems, callback) {

        var value, i = 0, length = elems.length, ret = [];

        if (isArraylike(elems)) for (;i < length; i++) null != (value = callback(elems[i], i)) && ret.push(value); else for (i in elems) null != (value = callback(elems[i], i)) && ret.push(value);

        return [].concat(ret);

    }, DependencyLib.data = function(owner, key, value) {

        if (void 0 === value) return owner.__data ? owner.__data[key] : null;

        owner.__data = owner.__data || {}, owner.__data[key] = value;

    }, "function" == typeof window.CustomEvent ? DependencyLib.Event = window.CustomEvent : (DependencyLib.Event = function(event, params) {

        params = params || {

            bubbles: !1,

            cancelable: !1,

            detail: void 0

        };

        var evt = document.createEvent("CustomEvent");

        return evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail), 

        evt;

    }, DependencyLib.Event.prototype = window.Event.prototype), DependencyLib;

});