jvm.VMLCanvasElement = function(container, width, height){

  this.classPrefix = 'VML';

  jvm.VMLCanvasElement.parentClass.call(this, 'group');

  jvm.AbstractCanvasElement.apply(this, arguments);

  this.node.style.position = 'absolute';

};



jvm.inherits(jvm.VMLCanvasElement, jvm.VMLElement);

jvm.mixin(jvm.VMLCanvasElement, jvm.AbstractCanvasElement);



jvm.VMLCanvasElement.prototype.setSize = function(width, height){

  var paths,

      groups,

      i,

      l;



  this.width = width;

  this.height = height;

  this.node.style.width = width + "px";

  this.node.style.height = height + "px";

  this.node.coordsize = width+' '+height;

  this.node.coordorigin = "0 0";

  if (this.rootElement) {

    paths = this.rootElement.node.getElementsByTagName('shape');

    for(i = 0, l = paths.length; i < l; i++) {

      paths[i].coordsize = width+' '+height;

      paths[i].style.width = width+'px';

      paths[i].style.height = height+'px';

    }

    groups = this.node.getElementsByTagName('group');

    for(i = 0, l = groups.length; i < l; i++) {

      groups[i].coordsize = width+' '+height;

      groups[i].style.width = width+'px';

      groups[i].style.height = height+'px';

    }

  }

};



jvm.VMLCanvasElement.prototype.applyTransformParams = function(scale, transX, transY) {

  this.scale = scale;

  this.transX = transX;

  this.transY = transY;

  this.rootElement.node.coordorigin = (this.width-transX-this.width/100)+','+(this.height-transY-this.height/100);

  this.rootElement.node.coordsize = this.width/scale+','+this.height/scale;

};