jvm.VMLPathElement = function(config, style){

  var scale = new jvm.VMLElement('skew');



  jvm.VMLPathElement.parentClass.call(this, 'shape', config, style);



  this.node.coordorigin = "0 0";



  scale.node.on = true;

  scale.node.matrix = '0.01,0,0,0.01,0,0';

  scale.node.offset = '0,0';



  this.node.appendChild(scale.node);

};



jvm.inherits(jvm.VMLPathElement, jvm.VMLShapeElement);



jvm.VMLPathElement.prototype.applyAttr = function(attr, value){

  if (attr === 'd') {

    this.node.path = jvm.VMLPathElement.pathSvgToVml(value);

  } else {

    jvm.VMLShapeElement.prototype.applyAttr.call(this, attr, value);

  }

};



jvm.VMLPathElement.pathSvgToVml = function(path) {

  var result = '',

      cx = 0, cy = 0, ctrlx, ctrly;



  path = path.replace(/(-?\d+)e(-?\d+)/g, '0');

  return path.replace(/([MmLlHhVvCcSs])\s*((?:-?\d*(?:\.\d+)?\s*,?\s*)+)/g, function(segment, letter, coords, index){

    coords = coords.replace(/(\d)-/g, '$1,-')

            .replace(/^\s+/g, '')

            .replace(/\s+$/g, '')

            .replace(/\s+/g, ',').split(',');

    if (!coords[0]) coords.shift();

    for (var i=0, l=coords.length; i<l; i++) {

      coords[i] = Math.round(100*coords[i]);

    }

    switch (letter) {

      case 'm':

        cx += coords[0];

        cy += coords[1];

        return 't'+coords.join(',');

      break;

      case 'M':

        cx = coords[0];

        cy = coords[1];

        return 'm'+coords.join(',');

      break;

      case 'l':

        cx += coords[0];

        cy += coords[1];

        return 'r'+coords.join(',');

      break;

      case 'L':

        cx = coords[0];

        cy = coords[1];

        return 'l'+coords.join(',');

      break;

      case 'h':

        cx += coords[0];

        return 'r'+coords[0]+',0';

      break;

      case 'H':

        cx = coords[0];

        return 'l'+cx+','+cy;

      break;

      case 'v':

        cy += coords[0];

        return 'r0,'+coords[0];

      break;

      case 'V':

        cy = coords[0];

        return 'l'+cx+','+cy;

      break;

      case 'c':

        ctrlx = cx + coords[coords.length-4];

        ctrly = cy + coords[coords.length-3];

        cx += coords[coords.length-2];

        cy += coords[coords.length-1];

        return 'v'+coords.join(',');

      break;

      case 'C':

        ctrlx = coords[coords.length-4];

        ctrly = coords[coords.length-3];

        cx = coords[coords.length-2];

        cy = coords[coords.length-1];

        return 'c'+coords.join(',');

      break;

      case 's':

        coords.unshift(cy-ctrly);

        coords.unshift(cx-ctrlx);

        ctrlx = cx + coords[coords.length-4];

        ctrly = cy + coords[coords.length-3];

        cx += coords[coords.length-2];

        cy += coords[coords.length-1];

        return 'v'+coords.join(',');

      break;

      case 'S':

        coords.unshift(cy+cy-ctrly);

        coords.unshift(cx+cx-ctrlx);

        ctrlx = coords[coords.length-4];

        ctrly = coords[coords.length-3];

        cx = coords[coords.length-2];

        cy = coords[coords.length-1];

        return 'c'+coords.join(',');

      break;

    }

    return '';

  }).replace(/z/g, 'e');

};