//! moment.js locale configuration

//! locale : Central Atlas Tamazight [tzm]

//! author : Abdel Said : https://github.com/abdelsaid



import moment from '../moment';



export default moment.defineLocale('tzm', {

    months : 'ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ'.split('_'),

    monthsShort : 'ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ'.split('_'),

    weekdays : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),

    weekdaysShort : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),

    weekdaysMin : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),

    longDateFormat : {

        LT : 'HH:mm',

        LTS: 'HH:mm:ss',

        L : 'DD/MM/YYYY',

        LL : 'D MMMM YYYY',

        LLL : 'D MMMM YYYY HH:mm',

        LLLL : 'dddd D MMMM YYYY HH:mm'

    },

    calendar : {

        sameDay: '[ⴰⵙⴷⵅ ⴴ] LT',

        nextDay: '[ⴰⵙⴽⴰ ⴴ] LT',

        nextWeek: 'dddd [ⴴ] LT',

        lastDay: '[ⴰⵚⴰⵏⵜ ⴴ] LT',

        lastWeek: 'dddd [ⴴ] LT',

        sameElse: 'L'

    },

    relativeTime : {

        future : 'ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s',

        past : 'ⵢⴰⵏ %s',

        s : 'ⵉⵎⵉⴽ',

        ss : '%d ⵉⵎⵉⴽ',

        m : 'ⵎⵉⵏⵓⴺ',

        mm : '%d ⵎⵉⵏⵓⴺ',

        h : 'ⵙⴰⵄⴰ',

        hh : '%d ⵜⴰⵙⵙⴰⵄⵉⵏ',

        d : 'ⴰⵙⵙ',

        dd : '%d oⵙⵙⴰⵏ',

        M : 'ⴰⵢoⵓⵔ',

        MM : '%d ⵉⵢⵢⵉⵔⵏ',

        y : 'ⴰⵙⴳⴰⵙ',

        yy : '%d ⵉⵙⴳⴰⵙⵏ'

    },

    week : {

        dow : 6, // Saturday is the first day of the week.

        doy : 12  // The week that contains Jan 12th is the first week of the year.

    }

});



